cmp.unfold <- function(x,data,...){
    latent.dims <- all.vars(x[c(1,3)])
    ndims <- length(latent.dims)
    formula <- x[1:2]
    formula <- update(formula,~.-1)
    cl <- match.call()
    m <- match.call(expand.dots=FALSE)
    mf <- m[c(1,match(c("formula","data","subset"),
            names(m),nomatch=0L))]
    mf[[1]] <- as.name("model.frame")
    mf$formula <- formula
    mf <- eval(mf,parent.frame())

    mf <- within(mf,
      foreach(x=as.symbols(names(mf)),{
        x <- ifelse(x > 0,x,.1)
        }
      ))
    rsum <- rowSums(mf)
    mf <- within(mf,
      foreach(x=as.symbols(names(mf)),{
        x <- x/rsum
        x <- -log(x)
        }
      ))

    unfold(x,data=mf,squared=TRUE,...)
}